<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use App\Models\Docente;
use App\Models\Usuario;
use App\Models\Curso;
use App\Models\CursoDocente;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Models\Instituto;
use Barryvdh\DomPDF\Facade\Pdf;

class CaratulaController extends Controller
{
   

    public function pdf($curso_id)
    {
        $curso = DB::table('docentes as d')
            ->join('cursos_docentes as cd', 'd.id', '=', 'cd.docente_id')
            ->join('cursos as c', 'cd.curso_id', '=', 'c.id')
            ->join('semestres as s', 's.id', '=', 'c.semestre_id')
            ->join('modulos_formativos as m', 'm.id_modulo', '=', 'c.id_modulo')
            ->join('cursos_plan_estudio as cp', 'cp.curso_id', '=', 'c.id')
            ->join('planes_estudio as p', 'p.id', '=', 'cp.plan_estudio_id')
            ->join('planes_estudio_periodos as pep', 'p.id', '=', 'pep.plan_estudio_id')
            ->join('periodos as pe', 'pe.id', '=', 'pep.periodo_id')
            ->select(
                'c.id',
                DB::raw('d.nombre as docente'),
                DB::raw('d.apellido as apellido'),
                'c.nombre as curso',
                'c.tipo',
                'c.creditos',
                's.nombre as semestre',
                'm.nombre as modulo',
                'c.horas_semestrales',
                'p.nombre as carrera',
                'pe.nombre as periodo'
            )
            ->where('c.id', $curso_id)
            ->where('pe.activo', '1')
            ->first();

        if (!$curso) {
            abort(404, 'No se encontró el curso.');
        }

        $instituto = Instituto::first();

        return Pdf::loadView('docentes.caratulas.pdf', compact('curso', 'instituto'))
            ->setPaper('A4', 'portrait')
            ->stream('caratula_curso.pdf');
    }


    



}
