@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Requisitos @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalNuevoInstituto">
                    <i class="fas fa-plus"></i> Agregar Nuevo Instituto
                </button>
                <div class="table-responsive">
                @if ($instituto)
                <table id="tablaInstituto" class="table table-striped mb-0 table-hover">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Dirección</th>
                            <th>Teléfono</th>
                            <th>Código Modular</th>
                            <th>DRE</th>
                            <th>Logo</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ $instituto->nombre }}</td>
                            <td>{{ $instituto->direccion }}</td>
                            <td>{{ $instituto->telefono }}</td>
                            <td>{{ $instituto->codigo_modular }}</td>
                            <td>{{ $instituto->dre }}</td>
                            <td>
                                @if ($instituto->logo)
                                    <img src="{{ asset('storage/' . $instituto->logo) }}" alt="Logo" width="150">
                                @else
                                    <span class="text-muted">No disponible</span>
                                @endif
                            </td>
                            <td>
                                <a href="#"
                                    class="text-warning btn-editar-instituto"
                                    data-bs-toggle="modal"
                                    data-bs-target="#modalEditarInstituto"
                                    data-id="{{ $instituto->id }}"
                                    data-nombre="{{ $instituto->nombre }}"
                                    data-direccion="{{ $instituto->direccion }}"
                                    data-telefono="{{ $instituto->telefono }}"
                                    data-codigo_modular="{{ $instituto->codigo_modular }}"
                                    data-dre="{{ $instituto->dre }}"
                                    data-logo="{{ $instituto->logo }}"
                                    data-nombre_departamento="{{ $instituto->departamento }}"
                                    data-nombre_provincia="{{ $instituto->provincia }}"
                                    data-nombre_distrito="{{ $instituto->distrito }}"
                                    data-id_departamento="{{ $departamentos->firstWhere('Departamento', $instituto->departamento)?->idDepa }}"
                                    data-id_provincia="{{ $provincias->firstWhere('Provincia', $instituto->provincia)?->idProv }}"
                                    data-id_distrito="{{ $distritos->firstWhere('Distrito', $instituto->distrito)?->idDist }}">
                                    <i class="las la-pen text-secondary font-18"></i>
                                </a>
                            </td>

                        </tr>
                    </tbody>
                </table>


                    
                @else
                    <div class="alert alert-info text-center">
                        Aún no se ha registrado el instituto.
                    </div>
                @endif



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->

<!-- Modal Nuevo Instituto -->
<div class="modal fade" id="modalNuevoInstituto" tabindex="-1" aria-labelledby="modalNuevoInstitutoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form action="{{ route('instituto.store') }}" method="POST" enctype="multipart/form-data">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalNuevoInstitutoLabel">Registrar Nuevo Instituto</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body row g-3">
          <div class="col-md-6">
            <input type="hidden" name="nombre_departamento" id="nombre_departamento">
            <input type="hidden" name="nombre_provincia" id="nombre_provincia">
            <input type="hidden" name="nombre_distrito" id="nombre_distrito">

            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" name="nombre" class="form-control" required>
          </div>
          <div class="col-md-6">
            <label for="direccion" class="form-label">Dirección</label>
            <input type="text" name="direccion" class="form-control">
          </div>
          <div class="col-md-6">
            <label for="telefono" class="form-label">Teléfono</label>
            <input type="text" name="telefono" class="form-control">
          </div>
          <div class="col-md-6">
            <label for="codigo_modular" class="form-label">Código Modular</label>
            <input type="text" name="codigo_modular" class="form-control">
          </div>
          <div class="col-md-6">
            <label for="dre" class="form-label">DRE</label>
            <input type="text" name="dre" class="form-control">
          </div>
          
          <!-- Selects encadenados -->
          <div class="col-md-6">
            <label for="departamento" class="form-label">Departamento</label>
            <select name="departamento" id="departamento" class="form-select" required>
              <option value="">Seleccionar</option>
              @foreach ($departamentos as $departamento)
                <option value="{{ $departamento->idDepa }}" data-nombre="{{ $departamento->Departamento }}">{{ $departamento->Departamento }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-6">
            <label for="provincia" class="form-label">Provincia</label>
            <select name="provincia" id="provincia" class="form-select" required >
              <option value="">Seleccionar</option>
            </select>
          </div>
          <div class="col-md-6">
            <label for="distrito" class="form-label">Distrito</label>
            <select name="distrito" id="distrito" class="form-select" required >
              <option value="">Seleccionar</option>
            </select>
          </div>

          <div class="col-md-6">
            <label for="logo" class="form-label">Logo (opcional)</label>
            <input type="file" name="logo" class="form-control" accept="image/*">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>




<!-- Modal -->

<div class="modal fade" id="modalEditarInstituto" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <form id="formEditarInstituto" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')
      <input type="hidden" id="edit_id">

      <input type="hidden" name="nombre_departamento" id="edit_nombre_departamento">
      <input type="hidden" name="nombre_provincia" id="edit_nombre_provincia">
      <input type="hidden" name="nombre_distrito" id="edit_nombre_distrito">

      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Editar Instituto</h5>
          <button class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body row g-3">
          <div class="col-md-6">
            <label>Nombre</label>
            <input type="text" id="edit_nombre" name="nombre" class="form-control" required>
          </div>

          <div class="col-md-6">
            <label>Dirección</label>
            <input type="text" id="edit_direccion" name="direccion" class="form-control">
          </div>

          <div class="col-md-6">
            <label>Teléfono</label>
            <input type="text" id="edit_telefono" name="telefono" class="form-control">
          </div>

          <div class="col-md-6">
            <label>Código Modular</label>
            <input type="text" id="edit_codigo_modular" name="codigo_modular" class="form-control">
          </div>

          <div class="col-md-6">
            <label>DRE</label>
            <input type="text" id="edit_dre" name="dre" class="form-control">
          </div>

          <div class="col-md-6">
            <label>Departamento</label>
            <select id="edit_departamento" name="departamento" class="form-select" required>
              <option value="">Seleccionar</option>
              @foreach ($departamentos as $d)
                <option value="{{ $d->idDepa }}" data-nombre="{{ $d->Departamento }}">
                  {{ $d->Departamento }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="col-md-6">
            <label>Provincia</label>
            <select id="edit_provincia" name="provincia" class="form-select" required>
              <option value="">Seleccionar</option>
            </select>
          </div>

          <div class="col-md-6">
            <label>Distrito</label>
            <select id="edit_distrito" name="distrito" class="form-select" required>
              <option value="">Seleccionar</option>
            </select>
          </div>

          <div class="col-md-6">
            <label>Logo</label>
            <input type="file" name="logo" class="form-control">
            <img id="preview_logo" class="mt-2 rounded d-none" width="120">
          </div>
        </div>

        <div class="modal-footer">
          <button class="btn btn-primary">Actualizar</button>
          <button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables CSS -->
<script>
    $(document).ready(function () {
        $("#tablaInstituto").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaInstituto_wrapper .col-md-6:eq(0)');
    });
</script>

<!-- cambios de departamento -->
<script>
  $(document).ready(function () {

    /* =====================================================
       NUEVO INSTITUTO
    ===================================================== */
    $('#departamento').on('change', function () {
        let id = $(this).val();
        $('#provincia').html('<option>Cargando...</option>');
        $('#distrito').html('<option>Seleccionar</option>');

        if (id) {
            $.get('/instituto/provincias/' + id, function (data) {
                let opt = '<option value="">Seleccionar</option>';
                data.forEach(p => {
                    opt += `<option value="${p.idProv}" data-nombre="${p.Provincia}">
                              ${p.Provincia}
                            </option>`;
                });
                $('#provincia').html(opt);
            });
        }
    });

    $('#provincia').on('change', function () {
        let id = $(this).val();
        $('#distrito').html('<option>Cargando...</option>');

        if (id) {
            $.get('/instituto/distritos/' + id, function (data) {
                let opt = '<option value="">Seleccionar</option>';
                data.forEach(d => {
                    opt += `<option value="${d.idDist}" data-nombre="${d.Distrito}">
                              ${d.Distrito}
                            </option>`;
                });
                $('#distrito').html(opt);
            });
        }
    });

    /* =====================================================
       EDITAR INSTITUTO
      ===================================================== */
      $('#edit_departamento').on('change', function () {
          let id = $(this).val();
          $('#edit_provincia').html('<option>Cargando...</option>');
          $('#edit_distrito').html('<option>Seleccionar</option>');

          if (id) {
              $.get('/instituto/provincias/' + id, function (data) {
                  let opt = '<option value="">Seleccionar</option>';
                  data.forEach(p => {
                      opt += `<option value="${p.idProv}" data-nombre="${p.Provincia}">
                                ${p.Provincia}
                              </option>`;
                  });
                  $('#edit_provincia').html(opt);
              });
          }
      });

      $('#edit_provincia').on('change', function () {
          let id = $(this).val();
          $('#edit_distrito').html('<option>Cargando...</option>');

          if (id) {
              $.get('/instituto/distritos/' + id, function (data) {
                  let opt = '<option value="">Seleccionar</option>';
                  data.forEach(d => {
                      opt += `<option value="${d.idDist}" data-nombre="${d.Distrito}">
                                ${d.Distrito}
                              </option>`;
                  });
                  $('#edit_distrito').html(opt);
              });
          }
      });

  });
</script>


<script>
$(document).on('click', '.btn-editar-instituto', function () {

    let b = $(this);

    $('#edit_nombre').val(b.data('nombre'));
    $('#edit_direccion').val(b.data('direccion'));
    $('#edit_telefono').val(b.data('telefono'));
    $('#edit_codigo_modular').val(b.data('codigo_modular'));
    $('#edit_dre').val(b.data('dre'));

    $('#edit_nombre_departamento').val(b.data('nombre_departamento'));
    $('#edit_nombre_provincia').val(b.data('nombre_provincia'));
    $('#edit_nombre_distrito').val(b.data('nombre_distrito'));

    let id = b.data('id');
    $('#formEditarInstituto').attr('action', `/instituto/${id}`);

    $('#edit_departamento').val(b.data('id_departamento')).trigger('change');

    if (b.data('logo')) {
        $('#preview_logo').attr('src', `/storage/${b.data('logo')}`).removeClass('d-none');
    } else {
        $('#preview_logo').addClass('d-none');
    }

    $('#modalEditarInstituto').modal('show');
});
</script>


@endsection
