<div class="table-responsive">
    <table id="tablaPeriodos" class="table table-striped table-hover">
        <thead class="table-light">
            <tr>
                <th>Código Matrícula</th>
                <th>Postulante</th>
                <th>Plan de Estudio</th>
                <th>Periodo</th>
                <th>Semestre</th>
                <th>Estado</th>
                <th>Fecha Matrícula</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $matriculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matricula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($matricula->codigo_matricula); ?></td>
                    <td><?php echo e($matricula->postulante->nombres); ?> <?php echo e($matricula->postulante->apellidos); ?></td>
                    <td><?php echo e($matricula->planEstudio->nombre); ?></td>
                    <td><?php echo e($matricula->periodo->nombre); ?></td>
                    <td><?php echo e($matricula->semestre->nombre); ?></td>
                    <td>
                        <?php
                            $estados = [
                                'Matriculado' => 'success',
                                'Pendiente' => 'warning',
                                'Retirado' => 'danger',
                                'Convalidado' => 'info',
                                'Repitencia' => 'secondary',
                            ];
                        ?>
                        <span class="badge bg-<?php echo e($estados[$matricula->estado] ?? 'dark'); ?>"><?php echo e($matricula->estado); ?></span>
                    </td>
                    <td><?php echo e(\Carbon\Carbon::parse($matricula->fecha_matricula)->format('d/m/Y')); ?></td>
                    <td>
                        

                        <a href="#" class="btn-editar-matricula" data-bs-toggle="modal" data-bs-target="#editModal"
                            data-id="<?php echo e($matricula->id); ?>"
                            data-codigo="<?php echo e($matricula->codigo_matricula); ?>"
                            data-postulante="<?php echo e($matricula->postulante_id); ?>"
                            data-plan="<?php echo e($matricula->plan_estudio_id); ?>"
                            data-periodo="<?php echo e($matricula->periodo_id); ?>"
                            data-semestre="<?php echo e($matricula->semestre_id); ?>"
                            data-estado="<?php echo e($matricula->estado); ?>"
                            data-fecha="<?php echo e($matricula->fecha_matricula); ?>">
                            <i class="las la-pen text-secondary font-18"></i>
                        </a>

                        <a href="#" class="text-danger btn-eliminar-matricula" data-id="<?php echo e($matricula->id); ?>">
                            <i class="las la-trash-alt text-secondary font-18"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/dedu/public_html/iestpjuanhuarin.dedu.pe/resources/views/matriculas/partials/tabla.blade.php ENDPATH**/ ?>